#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Beam bendingMod01.fsh  by  byt3_m3chanic
//https://www.shadertoy.com/view/wdSXzt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Beam bending - Just shader-writing practice of a random idea.
//
// Copyright 2019 Mirco Müller
//
// Author(s):
//   Mirco "MacSlow" Müller <macslow@gmail.com>
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License version 3, as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranties of
// MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
// PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////

mat2 r2d (float deg) {
	float rad = radians (deg);
	float c = cos (rad);
	float s = sin (rad);
	return mat2 (c,s,-s,c);
}

float texNoise (vec2 p) {
	return texture (iChannel0, p).r;
}

float smin (float d1, float d2, float k) {
	float h = clamp (.5 + .5*(d2 - d1)/k, .0, 1.);
	return mix (d2, d1, h) - h*k*(1. - h);
}

float map (vec3 p, inout int id, inout vec3 pout) {
	float size = 3.;
	float offset = cos (.2*iTime);
	float offset2 = cos (iTime);
	float ground = p.y + size + offset2 + .75*texNoise (offset+.05*p.xz+.1*iTime);
	ground = min (ground, -p.y + size + offset2 + .75*texNoise (offset-.1*iTime+.075*p.xz + 1.));
	float wall = p.z + 3.*size;
	wall = min (wall, -p.z + 3.*size);
	wall = min (wall, p.x + 2.*size);
	wall = min (wall, -p.x + 2.*size);
	vec3 pbar = p;
	pbar.xz *= r2d (25.*cos (pbar.y + sin(3.*iTime)));
	pbar.xy *= r2d (9.*cos (pbar.y + sin(4.*iTime)));
	pbar.yz *= r2d (9.*sin (pbar.y + sin(2.*iTime)));

	pbar.x += .2*cos (pbar.y + 2.*iTime);
	pbar.z += -(.3*(cos(2.*iTime)))*sin (2.*pbar.y + 2.*iTime);
	float thickness = .5-.2*offset2*cos (2.*pbar.y+3.*iTime);
	vec3 s = vec3 (thickness, 3.5, thickness);
	float bar = length (max (vec3 (.0), abs (pbar) - s)) - .1;
	float d = min (wall, smin (ground, bar, 1.5));
	id = 1;
    pout = pbar;
	if (d == wall) {id = 2; pout = p;}
    return d;
}

float march (vec3 ro, vec3 rd, inout int id, inout vec3 pout)
{
	float t = .0;
	float d = .0;
	for (int i = 0; i< 64; ++i) {
		vec3 p = ro+d*rd;
		t = map (p, id, pout);
		if (abs (t) < .000000001*(1. + .125*t)) break;
		d += t*.5;
	}
	return d;
}

vec3 norm (vec3 p){
	int foo;
	vec3 bar;
	float d = map (p, foo, bar);
	vec2 e = vec2 (.01, .0);
	return normalize (vec3 (map (p+e.xyy, foo, bar),
                            map (p+e.yxy, foo, bar),
                            map (p+e.yyx, foo, bar))-d);
}

float sha (vec3 p, vec3 lp, vec3 n, vec3 ldir) {
	float d2l = distance (lp, p);
	int foo;
	vec3 bar;
	float d2w = march (p+.01*n, ldir, foo, bar);
	return d2l < d2w ? 1. : .1;
}

vec3 shade (vec3 ro, vec3 rd, float d, vec3 n, vec3 lp, vec3 lc, float li, int id, vec3 pout) {
    vec3 p = ro + d*rd;
	float ld = distance (p, lp); 
	vec3 ldir = normalize (lp - p);
	float att = 12. / (ld*ld);
	vec3 mat = vec3 (1., .0, .0);
	if (id == 1) mat = vec3 (.0);
	if (id == 2) mat = mix (vec3 (.0), vec3 (1.), smoothstep (.0, .5, sin (3.*p.y+5.*iTime)));
	float s = sha (p, lp, n, ldir);
	float diff = max (.0, dot (n, ldir));
	vec3 h = normalize (-rd + ldir);
	float shiny = 40.;
	float sp = pow (max (.0, dot (n, h)), shiny);
	vec3 am = vec3 (.05);
	return att*s*(am + diff*lc*li*mat + sp*vec3 (1.));
}

vec3 cam (vec2 uv, vec3 ro, vec3 aim, float z) {
	vec3 f = normalize (aim - ro);
	vec3 wu = vec3 (.0, 1., .0);
	vec3 r = normalize (cross (wu, f));
	vec3 u = normalize (cross (f, r));
	vec3 c = ro + f*z;
	return normalize(c + r*uv.x + u*uv.y - ro);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uvRaw = fragCoord/iResolution.xy;
	vec2 uv = uvRaw*2. - 1.;
	uv.x *= iResolution.x/iResolution.y;
	uv *= 1. + .25*length (uv);

	float dist = 3.;
	vec3 ro = vec3 (dist*cos (iTime), .0, dist*sin(iTime));
	vec3 rd = cam (uv, ro, vec3 (.0), 1.25);
	int id = 0;
	vec3 pout = vec3 (.0);
	float d = march (ro, rd, id, pout);
	vec3 p = ro + d*rd;
	vec3 n = norm (p);
	vec3 c = shade (ro, rd, d, n, vec3 (.0, .0, 2.), vec3 (.9, .85, .3), 2.,id, pout);
	c += shade (ro, rd, d, n, vec3 (2., 2., -2.), vec3 (.5, .5, .9), 2.,id, pout);

	if (id == 1) {
		ro = p + .01*n;
		rd = normalize (reflect (rd, n));
		d = march (ro, rd, id, pout);
		p = ro + d*rd;
		n = norm(p);
		vec3 rc = shade (ro, rd, d, n, vec3 (.0, .0, 2.), vec3 (.9, .85, .3), 2.,id, pout);
		rc += shade (ro, rd, d, n, vec3 (2., 2., -2.), vec3 (.3, .3, .9), 2.,id, pout);
		c += .3*rc;
	}
	c=c/(1.25+c*.5);
	c*=1.-.65*length(uvRaw*2.-1.);
	c*=mix(1.,.75,cos(500.*uvRaw.y));
	c=pow(c,vec3(1./2.2));

    fragColor = vec4(c,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

